<?php
/**
 * Admin Clients
 *
 * @package blesta
 * @subpackage blesta.language.es_es
 * @copyright Copyright (c) 2025, Phillips Data, Inc.
 * @license http://www.blesta.com/license/ The Blesta License Agreement
 * @link http://www.blesta.com/ Blesta
 */

$lang['AdminClients.!success.note_added'] = 'La nota se ha creado correctamente.';
$lang['AdminClients.!success.note_updated'] = 'La nota se ha actualizado correctamente.';
$lang['AdminClients.!success.note_deleted'] = 'La nota se ha eliminado correctamente.';
$lang['AdminClients.!success.client_added'] = 'El cliente se ha creado correctamente.';
$lang['AdminClients.!success.client_updated'] = 'El cliente se ha actualizado correctamente.';
$lang['AdminClients.!success.client_deleted'] = 'El cliente se ha eliminado correctamente.';
$lang['AdminClients.!success.contact_added'] = 'El contacto se ha creado correctamente.';
$lang['AdminClients.!success.contact_updated'] = 'El contacto se ha actualizado correctamente.';
$lang['AdminClients.!success.invoice_added'] = 'La factura #%1$s se ha creado correctamente.';
$lang['AdminClients.!success.invoice_updated'] = 'La factura #%1$s se ha actualizado correctamente.';
$lang['AdminClients.!success.draftinvoice_added'] = 'Se ha creado correctamente el borrador de factura #%1$s.';
$lang['AdminClients.!success.draftinvoice_updated'] = 'El borrador de factura #%1$s se ha actualizado correctamente.';
$lang['AdminClients.!success.draftinvoice_created'] = 'El borrador de factura #%1$s se ha creado correctamente como factura #%2$s.';
$lang['AdminClients.!success.quotation_added'] = 'Se ha creado correctamente la cita #%1$s.';
$lang['AdminClients.!success.quotation_updated'] = 'La cita #%1$s se ha actualizado correctamente.';
$lang['AdminClients.!success.draftquotation_added'] = 'Se ha creado correctamente el proyecto de presupuesto #%1$s.';
$lang['AdminClients.!success.draftquotation_updated'] = 'El proyecto de presupuesto #%1$s se ha actualizado correctamente.';
$lang['AdminClients.!success.approvequotation_approved'] = 'El presupuesto #%1$s ha sido aprobado.';
$lang['AdminClients.!success.invoicequotation_invoiced'] = 'El presupuesto #%1$s se ha facturado correctamente como factura #%2$s.';
$lang['AdminClients.!success.addccaccount_added'] = 'La cuenta de la tarjeta de crédito se ha creado correctamente.';
$lang['AdminClients.!success.editccaccount_updated'] = 'La cuenta de la tarjeta de crédito se ha editado correctamente.';
$lang['AdminClients.!success.addachaccount_added'] = 'La cuenta ACH se ha creado correctamente.';
$lang['AdminClients.!success.editachaccount_updated'] = 'La cuenta ACH se ha editado correctamente.';
$lang['AdminClients.!success.deleteccaccount_deleted'] = 'La cuenta de pago se ha eliminado correctamente.';
$lang['AdminClients.!success.deleteachaccount_deleted'] = 'La cuenta de pago se ha eliminado correctamente.';
$lang['AdminClients.!success.verifyachaccount_verified'] = 'La cuenta de pago se ha verificado correctamente.';
$lang['AdminClients.!success.accounts_updated'] = 'Se ha actualizado la cuenta de pago que se utilizará para el adeudo automático.';
$lang['AdminClients.!success.accounts_deleted'] = 'Se ha eliminado la cuenta de pago que se utilizará para el adeudo automático.';
$lang['AdminClients.!success.accounttypes_updated'] = 'La configuración del tipo de pago aceptado se ha actualizado correctamente.';
$lang['AdminClients.!success.recurinvoice_deleted'] = 'La factura periódica se ha eliminado correctamente.';
$lang['AdminClients.!success.recurinvoice_updated'] = 'La factura periódica se ha actualizado correctamente.';
$lang['AdminClients.!success.edittransaction_updated'] = 'La transacción se ha actualizado correctamente.';
$lang['AdminClients.!success.transaction_unapplied'] = 'La transacción se ha anulado correctamente de la factura.';
$lang['AdminClients.!success.invoices_queued'] = 'Las facturas seleccionadas se han puesto en cola para su entrega.';
$lang['AdminClients.!success.invoices_delivered'] = 'Las facturas seleccionadas se han entregado correctamente.';
$lang['AdminClients.!success.invoices_voided'] = 'Las siguientes facturas se han anulado correctamente: %1$s.';
$lang['AdminClients.!success.quotations_delivered'] = 'Los presupuestos seleccionados se entregaron con éxito.';
$lang['AdminClients.!success.quotations_status_updated'] = 'Se han actualizado correctamente las siguientes citas: %1$s.';
$lang['AdminClients.!success.makepayment_processed'] = 'El pago de %1$s se ha procesado correctamente. Número de transacción: %2$s';
$lang['AdminClients.!success.recordpayment_processed'] = 'El pago se ha registrado correctamente para %1$s.';
$lang['AdminClients.!success.recordpayment_credits'] = 'Los créditos se grabaron correctamente.';
$lang['AdminClients.!success.deletedraftinvoice_deleted'] = 'El borrador de factura se ha eliminado correctamente.';
$lang['AdminClients.!success.email_sent'] = 'El correo electrónico se ha enviado correctamente.';
$lang['AdminClients.!success.contact_deleted'] = 'El contacto %1$s %2$s se ha eliminado correctamente.';
$lang['AdminClients.!success.service_added'] = 'El servicio se ha añadido correctamente.';
$lang['AdminClients.!success.service_edited'] = 'El servicio se ha actualizado correctamente.';
$lang['AdminClients.!success.service_deleted'] = 'El servicio se ha eliminado correctamente.';
$lang['AdminClients.!success.packages_restricted'] = 'Se ha actualizado el acceso restringido a paquetes para este cliente.';
$lang['AdminClients.!success.service_tab'] = 'Los datos se han actualizado correctamente.';
$lang['AdminClients.!success.services_scheduled_cancel'] = 'Los servicios seleccionados fueron programados con éxito para ser cancelados.';
$lang['AdminClients.!success.services_scheduled_uncancel'] = 'Ya no está prevista la cancelación de los servicios seleccionados.';
$lang['AdminClients.!success.services_renewed'] = 'Los servicios seleccionados se renovaron con éxito.';
$lang['AdminClients.!success.services_pushed'] = 'Los servicios seleccionados se han transferido correctamente al nuevo cliente.';
$lang['AdminClients.!success.suspend_date_updated'] = 'La fecha de suspensión automática se ha actualizado correctamente.';
$lang['AdminClients.!success.passwordreset.sent'] = 'El correo electrónico de restablecimiento de contraseña se ha enviado correctamente.';
$lang['AdminClients.!error.invoices_emailinvalid'] = 'La dirección de correo electrónico no es válida.';
$lang['AdminClients.!error.password'] = 'La contraseña no es válida.';
$lang['AdminClients.!error.pay_with.required'] = 'Debe seleccionar un método de pago.';
$lang['AdminClients.!error.invoice_credits.required'] = 'Seleccione una factura a la que se puedan aplicar créditos.';
$lang['AdminClients.!error.quotation_invalid_status'] = 'El estado seleccionado no es válido.';
$lang['AdminClients.!error.future_cancel_date'] = 'La fecha prevista de cancelación no debe ser anterior.';
$lang['AdminClients.!error.invoices_not_voided'] = 'No se han podido anular las siguientes facturas porque contienen pagos parciales: %1$s.';
$lang['AdminClients.!error.passwordreset.failed'] = 'No se ha podido enviar el correo electrónico de restablecimiento de contraseña.';
$lang['AdminClients.!error.invoices_renew_service'] = 'El servicio no podrá renovarse hasta que se hayan abonado todas las facturas que lo contengan.';
$lang['AdminClients.!notice.invoice_tax_rules_differ'] = 'ADVERTENCIA: Esta factura contiene normas fiscales que ya no están en vigor. Si añade o elimina una partida o actualiza la cantidad, el coste unitario o el estado fiscal, se aplicarán las normas fiscales más recientes a esta factura.';
$lang['AdminClients.!notice.payment_type'] = 'ADVERTENCIA: %1$s pagos no están habilitados actualmente. Para habilitarlos, actualice el <a href="%2$s">%3$s</a>.';
$lang['AdminClients.!notice.transactions_already_applied'] = 'ADVERTENCIA: La modificación del estado de esta transacción eliminará esta transacción de todas las facturas aplicadas actualmente.';
$lang['AdminClients.!notice.service_in_review'] = 'El estado de este servicio es actualmente %1$s y debe cambiarse a %2$s antes de que pueda activarse. Esto puede hacerse a través del widget Pedidos de la página Resumen de facturación mediante el plugin Pedidos, o mediante un plugin de terceros responsable de la gestión de pedidos.';
$lang['AdminClients.!notice.queued_service_change'] = 'Este servicio tiene cambios pendientes. La actualización de este servicio para subir o bajar cualquiera de sus valores hará que se cancelen los cambios pendientes actuales.';
$lang['AdminClients.!notice.delete_client'] = 'Esto eliminará permanentemente el cliente y todos los registros asociados (por ejemplo, contactos, servicios, facturas, transacciones, cuentas de pago, etc.). SE TRATA DE UNA ACCIÓN PERMANENTE E IRREVOCABLE.';
$lang['AdminClients.!notice.passwordreset.client_inactive'] = 'El correo electrónico de restablecimiento de contraseña sólo puede enviarse a clientes que estén activos.';
$lang['AdminClients.!notice.client_limit'] = 'Este cliente ha alcanzado el número máximo de servicios para este paquete.';
$lang['AdminClients.!notice.force_email_usernames'] = 'Tu nombre de usuario será el mismo que tu dirección de correo electrónico.';
$lang['AdminClients.!notice.ach_verification'] = 'Deberá verificar esta cuenta antes de poder utilizarla para efectuar un pago.';
$lang['AdminClients.!notice.ach_edit'] = 'Después de editar esta cuenta, deberá verificarla antes de poder utilizarla para realizar un pago.';
$lang['AdminClients.!notice.void_invoice_pending_services'] = 'Está intentando anular una o más facturas que tienen servicios pendientes asociados. Si se anula la factura, no se deberá nada por el servicio pendiente y se activará.';
$lang['AdminClients.!tooltip.module_row_id'] = 'Al cambiar esta opción se actualizará la fila del módulo utilizada para este servicio sólo en Blesta. Esto puede afectar al modo en que el servicio se renueve con el módulo en el futuro.';
$lang['AdminClients.!tooltip.notify_cancel'] = 'El correo electrónico de cancelación sólo se enviará si la cancelación se produce inmediatamente. De lo contrario, el correo electrónico de cancelación programado se enviará inmediatamente, y el correo electrónico de cancelación se enviará en el momento de la cancelación en función de la configuración de la empresa o del grupo de clientes que controle este comportamiento.';
$lang['AdminClients.!tooltip.reset_contact_id'] = 'El correo electrónico de restablecimiento de contraseña se enviará al contacto seleccionado con un enlace para que pueda cambiar la contraseña de su cuenta.';
$lang['AdminClients.!tooltip.taxexempt'] = 'Este campo es gestionado automáticamente por el sistema fiscal.';
$lang['AdminClients.!tooltip.client_taxempt'] = 'Este cliente está exento de impuestos.';
$lang['AdminClients.index.page_title'] = 'Clientes';
$lang['AdminClients.index.boxtitle_browseclients'] = 'Clientes';
$lang['AdminClients.index.heading_client'] = 'ID de cliente';
$lang['AdminClients.index.heading_group'] = 'Grupo';
$lang['AdminClients.index.heading_name'] = 'Nombre';
$lang['AdminClients.index.heading_company'] = 'Empresa';
$lang['AdminClients.index.heading_email'] = 'Correo electrónico';
$lang['AdminClients.index.category_active'] = 'Activo';
$lang['AdminClients.index.category_inactive'] = 'Inactivo';
$lang['AdminClients.index.category_fraud'] = 'Fraude';
$lang['AdminClients.index.categorylink_clientsadd'] = 'Añadir cliente';
$lang['AdminClients.index.no_results'] = 'No hay clientes con este estatus.';
$lang['AdminClients.add.page_title'] = 'Clientes Crear nuevo cliente';
$lang['AdminClients.add.boxtitle_newclient'] = 'Nuevo cliente';
$lang['AdminClients.add.heading_contact'] = 'Información de contacto';
$lang['AdminClients.add.heading_billing'] = 'Información de facturación';
$lang['AdminClients.add.heading_authentication'] = 'Autenticación';
$lang['AdminClients.add.heading_settings'] = 'Ajustes adicionales';
$lang['AdminClients.add.field_firstname'] = 'Nombre';
$lang['AdminClients.add.field_lastname'] = 'Apellido';
$lang['AdminClients.add.field_company'] = 'Empresa/Org.';
$lang['AdminClients.add.field_title'] = 'Título';
$lang['AdminClients.add.field_address1'] = 'Dirección 1';
$lang['AdminClients.add.field_address2'] = 'Dirección 2';
$lang['AdminClients.add.field_city'] = 'Ciudad';
$lang['AdminClients.add.field_state'] = 'Estado/Provincia';
$lang['AdminClients.add.field_zip'] = 'Código postal';
$lang['AdminClients.add.field_country'] = 'País';
$lang['AdminClients.add.field_email'] = 'Correo electrónico';
$lang['AdminClients.add.field_username_type_email'] = 'Utilizar el correo electrónico como nombre de usuario';
$lang['AdminClients.add.field_username_type_username'] = 'Especifique un nombre de usuario';
$lang['AdminClients.add.field_username'] = 'Nombre de usuario';
$lang['AdminClients.add.field_newpassword'] = 'Contraseña';
$lang['AdminClients.add.text_generate_password'] = 'Generar contraseña';
$lang['AdminClients.add.field_taxexempt'] = 'Exento de impuestos';
$lang['AdminClients.add.field_taxid'] = 'Número de identificación fiscal/VATIN';
$lang['AdminClients.add.field_preferredcurrency'] = 'Moneda preferente';
$lang['AdminClients.add.field_language'] = 'Idioma';
$lang['AdminClients.add.field_clientgroup'] = 'Grupo de clientes';
$lang['AdminClients.add.field_send_registration_email'] = 'Enviar correo electrónico de registro de cuenta';
$lang['AdminClients.add.field_send_registration_message'] = 'Enviar mensaje de registro de cuenta';
$lang['AdminClients.add.field_receive_email_marketing'] = 'Suscripción a correos electrónicos de marketing';
$lang['AdminClients.add.field_clientsubmit'] = 'Crear cliente';
$lang['AdminClients.accounts.page_title'] = 'Cliente #%1$s Cuentas de pago';
$lang['AdminClients.accounts.boxtitle_accounts'] = 'Cuentas de pago';
$lang['AdminClients.accounts.categorylink_ach'] = 'Añadir cuenta ACH';
$lang['AdminClients.accounts.categorylink_cc'] = 'Añadir cuenta CC';
$lang['AdminClients.accounts.text_name'] = 'Nombre';
$lang['AdminClients.accounts.text_type'] = 'Tipo';
$lang['AdminClients.accounts.text_last4'] = '4 últimos';
$lang['AdminClients.accounts.text_options'] = 'Opciones';
$lang['AdminClients.accounts.confirm_delete'] = '¿De verdad eliminar esta cuenta de pago?';
$lang['AdminClients.accounts.option_verify'] = 'Verifique';
$lang['AdminClients.accounts.option_edit'] = 'Editar';
$lang['AdminClients.accounts.option_delete'] = 'Borrar';
$lang['AdminClients.accounts.type_cc'] = '%1$s - %2$s, expira %3$s';
$lang['AdminClients.accounts.type_ach'] = '%1$s - %2$s';
$lang['AdminClients.accounts.field_accountsubmit'] = 'Uso para débito automático';
$lang['AdminClients.accounts.no_results'] = 'No hay cuentas ACH ni CC.';
$lang['AdminClients.addccaccount.page_title'] = 'Cliente #%1$s Añadir cuenta de tarjeta de crédito';
$lang['AdminClients.addccaccount.boxtitle_addccaccount'] = 'Añadir cuenta de tarjeta de crédito';
$lang['AdminClients.addccaccount.field_accountsubmit'] = 'Crear cuenta';
$lang['AdminClients.addccaccount.text_none'] = 'Ninguno';
$lang['AdminClients.addCcAccount.text_cc'] = 'Tarjeta de crédito';
$lang['AdminClients.addachaccount.page_title'] = 'Cliente #%1$s Añadir cuenta ACH';
$lang['AdminClients.addachaccount.boxtitle_addachaccount'] = 'Añadir cuenta ACH';
$lang['AdminClients.addachaccount.field_accountsubmit'] = 'Crear cuenta';
$lang['AdminClients.addAchAccount.text_ach'] = 'ACH';
$lang['AdminClients.editccaccount.page_title'] = 'Cliente #%1$s Editar cuenta de tarjeta de crédito';
$lang['AdminClients.editccaccount.boxtitle_editccaccount'] = 'Editar cuenta de tarjeta de crédito';
$lang['AdminClients.editccaccount.field_accountsubmit'] = 'Editar cuenta';
$lang['AdminClients.editachaccount.page_title'] = 'Cliente #%1$s Editar cuenta ACH';
$lang['AdminClients.editachaccount.boxtitle_editachaccount'] = 'Editar cuenta ACH';
$lang['AdminClients.editachaccount.field_accountsubmit'] = 'Editar cuenta';
$lang['AdminClients.verifyachaccount.field_firstdeposit'] = 'Primer depósito';
$lang['AdminClients.verifyachaccount.field_seconddeposit'] = 'Segundo depósito';
$lang['AdminClients.verifyachaccount.boxtitle_verifyachaccount'] = 'Verificar cuenta ACH';
$lang['AdminClients.verifyachaccount.heading_deposits'] = 'Depósitos de verificación';
$lang['AdminClients.verifyachaccount.field_accountsubmit'] = 'Verificar cuenta';
$lang['AdminClients.verifyAchAccount.text_ach'] = 'ACH';
$lang['AdminClients.addcontact.page_title'] = 'Cliente #%1$s Nuevo contacto';
$lang['AdminClients.addcontact.boxtitle_newcontact'] = 'Nuevo contacto';
$lang['AdminClients.addcontact.heading_contact'] = 'Información de contacto';
$lang['AdminClients.addcontact.heading_authentication'] = 'Autenticación';
$lang['AdminClients.addcontact.field_enable_login'] = 'Activar inicio de sesión';
$lang['AdminClients.addcontact.field_username'] = 'Nombre de usuario';
$lang['AdminClients.addcontact.field_newpassword'] = 'Contraseña';
$lang['AdminClients.addcontact.text_generate_password'] = 'Generar contraseña';
$lang['AdminClients.addcontact.field_permissions'] = 'Permisos';
$lang['AdminClients.addcontact.heading_settings'] = 'Ajustes adicionales';
$lang['AdminClients.addcontact.field_firstname'] = 'Nombre';
$lang['AdminClients.addcontact.field_lastname'] = 'Apellido';
$lang['AdminClients.addcontact.field_company'] = 'Empresa/Org.';
$lang['AdminClients.addcontact.field_title'] = 'Título';
$lang['AdminClients.addcontact.field_address1'] = 'Dirección 1';
$lang['AdminClients.addcontact.field_address2'] = 'Dirección 2';
$lang['AdminClients.addcontact.field_city'] = 'Ciudad';
$lang['AdminClients.addcontact.field_state'] = 'Estado/Provincia';
$lang['AdminClients.addcontact.field_zip'] = 'Código postal';
$lang['AdminClients.addcontact.field_country'] = 'País';
$lang['AdminClients.addcontact.field_email'] = 'Correo electrónico';
$lang['AdminClients.addcontact.field_accounttype'] = 'Tipo de cuenta';
$lang['AdminClients.addcontact.field_contactsubmit'] = 'Crear contacto';
$lang['AdminClients.createinvoice.page_title'] = 'Cliente #%1$s Crear factura';
$lang['AdminClients.createinvoice.boxtitle_createinvoice'] = 'Crear factura';
$lang['AdminClients.createinvoice.heading_description'] = 'Descripción';
$lang['AdminClients.createinvoice.heading_quantity'] = 'Cantidad';
$lang['AdminClients.createinvoice.heading_unitcost'] = 'Coste unitario';
$lang['AdminClients.createinvoice.heading_tax'] = 'Impuesto';
$lang['AdminClients.createinvoice.heading_options'] = 'Opciones';
$lang['AdminClients.createinvoice.heading_term'] = 'Plazo';
$lang['AdminClients.createinvoice.heading_period'] = 'Periodo';
$lang['AdminClients.createinvoice.heading_duration'] = 'Duración';
$lang['AdminClients.createinvoice.heading_nextbilldate'] = 'Próxima fecha de renovación';
$lang['AdminClients.createinvoice.option_add'] = 'Añadir';
$lang['AdminClients.createinvoice.option_delete'] = 'Borrar';
$lang['AdminClients.createinvoice.field_datebilled'] = 'Fecha de facturación:';
$lang['AdminClients.createinvoice.field_datedue'] = 'Fecha de vencimiento:';
$lang['AdminClients.createinvoice.field_invoicedelivery'] = 'Entrega de facturas:';
$lang['AdminClients.createinvoice.field_autodebit'] = 'Débito automático:';
$lang['AdminClients.createinvoice.field_autodebit_text'] = 'Permitir el cargo automático de esta factura';
$lang['AdminClients.createinvoice.tooltip_autodebit'] = 'Al marcar esta casilla, se habilitará el débito automático de esta factura si el débito automático está habilitado y disponible para el cliente.';
$lang['AdminClients.createinvoice.field_currency'] = 'Moneda';
$lang['AdminClients.createinvoice.field_duration_indefinitely'] = 'Indefinidamente';
$lang['AdminClients.createinvoice.field_duration_times'] = 'número de veces';
$lang['AdminClients.createinvoice.field_notepublic'] = 'Nota pública:';
$lang['AdminClients.createinvoice.field_noteprivate'] = 'Nota privada:';
$lang['AdminClients.createinvoice.field_invoicesubmit'] = 'Cree';
$lang['AdminClients.createinvoice.field_invoicedraft'] = 'Guardar como borrador';
$lang['AdminClients.createinvoice.section_recurringinvoice'] = 'Factura recurrente';
$lang['AdminClients.createinvoice.section_notes'] = 'Notas';
$lang['AdminClients.createinvoice.price_subtotal'] = 'Subtotal:';
$lang['AdminClients.createinvoice.auto_save_saving'] = 'Guardar como borrador...';
$lang['AdminClients.createinvoice.auto_save_saved'] = 'Borrador guardado';
$lang['AdminClients.createinvoice.auto_save_error'] = 'No se ha podido autoguardar el borrador';
$lang['AdminClients.createquotation.page_title'] = 'Cliente #%1$s Crear presupuesto';
$lang['AdminClients.createquotation.boxtitle_createquotation'] = 'Crear presupuesto';
$lang['AdminClients.createquotation.heading_description'] = 'Descripción';
$lang['AdminClients.createquotation.heading_quantity'] = 'Cantidad';
$lang['AdminClients.createquotation.heading_unitcost'] = 'Coste unitario';
$lang['AdminClients.createquotation.heading_tax'] = 'Impuesto';
$lang['AdminClients.createquotation.heading_options'] = 'Opciones';
$lang['AdminClients.createquotation.option_add'] = 'Añadir';
$lang['AdminClients.createquotation.option_delete'] = 'Borrar';
$lang['AdminClients.createquotation.field_title'] = 'Título';
$lang['AdminClients.createquotation.field_date_created'] = 'Fecha de creación:';
$lang['AdminClients.createquotation.field_date_expires'] = 'Fecha de caducidad:';
$lang['AdminClients.createquotation.field_currency'] = 'Moneda';
$lang['AdminClients.createquotation.field_notes'] = 'Notas:';
$lang['AdminClients.createquotation.field_private_notes'] = 'Notas privadas:';
$lang['AdminClients.createquotation.field_quotationsubmit'] = 'Cree';
$lang['AdminClients.createquotation.field_quotationdraft'] = 'Guardar como borrador';
$lang['AdminClients.createquotation.section_notes'] = 'Notas';
$lang['AdminClients.createquotation.price_subtotal'] = 'Subtotal:';
$lang['AdminClients.createquotation.auto_save_saving'] = 'Guardar como borrador...';
$lang['AdminClients.createquotation.auto_save_saved'] = 'Borrador guardado';
$lang['AdminClients.createquotation.auto_save_error'] = 'No se ha podido autoguardar el borrador';
$lang['AdminClients.editquotation.page_title'] = 'Cliente #%1$s Editar presupuesto';
$lang['AdminClients.editquotation.boxtitle_editquotation'] = 'Editar cita [%1$s]';
$lang['AdminClients.editquotation.heading_description'] = 'Descripción';
$lang['AdminClients.editquotation.heading_quantity'] = 'Cantidad';
$lang['AdminClients.editquotation.heading_unitcost'] = 'Coste unitario';
$lang['AdminClients.editquotation.heading_tax'] = 'Impuesto';
$lang['AdminClients.editquotation.heading_options'] = 'Opciones';
$lang['AdminClients.editquotation.option_add'] = 'Añadir';
$lang['AdminClients.editquotation.option_delete'] = 'Borrar';
$lang['AdminClients.editquotation.field_title'] = 'Título';
$lang['AdminClients.editquotation.field_date_created'] = 'Fecha de creación:';
$lang['AdminClients.editquotation.field_date_expires'] = 'Fecha de caducidad:';
$lang['AdminClients.editquotation.field_currency'] = 'Moneda';
$lang['AdminClients.editquotation.field_notes'] = 'Notas:';
$lang['AdminClients.editquotation.field_private_notes'] = 'Notas privadas:';
$lang['AdminClients.editquotation.field_quotationsubmit'] = 'Guardar';
$lang['AdminClients.editquotation.field_quotationsavedraft'] = 'Guardar como borrador';
$lang['AdminClients.editquotation.section_notes'] = 'Notas';
$lang['AdminClients.editquotation.price_subtotal'] = 'Subtotal:';
$lang['AdminClients.editquotation.auto_save_saving'] = 'Guardar como borrador...';
$lang['AdminClients.editquotation.auto_save_saved'] = 'Borrador guardado';
$lang['AdminClients.editquotation.auto_save_error'] = 'No se ha podido autoguardar el borrador';
$lang['AdminClients.invoicequotation.field_invoice_single'] = 'Factura única';
$lang['AdminClients.invoicequotation.field_invoice_two'] = 'Dos facturas';
$lang['AdminClients.invoicequotation.field_due_date'] = 'Fecha de vencimiento';
$lang['AdminClients.invoicequotation.field_first_due_date'] = 'Primer vencimiento';
$lang['AdminClients.invoicequotation.field_second_due_date'] = 'Segundo vencimiento';
$lang['AdminClients.invoicequotation.field_percentage_due'] = 'Porcentaje vencido (%)';
$lang['AdminClients.invoicequotation.field_submit'] = 'Crear factura';
$lang['AdminClients.edit.page_title'] = 'Cliente #%1$s Modificar Cliente';
$lang['AdminClients.edit.boxtitle_editclient'] = 'Modificar cliente';
$lang['AdminClients.edit.heading_contact'] = 'Información de contacto';
$lang['AdminClients.edit.heading_billing'] = 'Información de facturación';
$lang['AdminClients.edit.heading_authentication'] = 'Autenticación';
$lang['AdminClients.edit.heading_settings'] = 'Ajustes adicionales';
$lang['AdminClients.edit.field_firstname'] = 'Nombre';
$lang['AdminClients.edit.field_lastname'] = 'Apellido';
$lang['AdminClients.edit.field_company'] = 'Empresa/Org.';
$lang['AdminClients.edit.field_title'] = 'Título';
$lang['AdminClients.edit.field_address1'] = 'Dirección 1';
$lang['AdminClients.edit.field_address2'] = 'Dirección 2';
$lang['AdminClients.edit.field_city'] = 'Ciudad';
$lang['AdminClients.edit.field_state'] = 'Estado/Provincia';
$lang['AdminClients.edit.field_zip'] = 'Código postal';
$lang['AdminClients.edit.field_country'] = 'País';
$lang['AdminClients.edit.field_email'] = 'Correo electrónico';
$lang['AdminClients.edit.field_username_type_email'] = 'Utilizar el correo electrónico como nombre de usuario';
$lang['AdminClients.edit.field_username_type_username'] = 'Especifique un nombre de usuario';
$lang['AdminClients.edit.field_username'] = 'Nombre de usuario';
$lang['AdminClients.edit.field_newpassword'] = 'Contraseña';
$lang['AdminClients.edit.field_two_factor_mode'] = 'Autenticación de dos factores';
$lang['AdminClients.edit.field_two_factor_mode_off'] = 'No activado';
$lang['AdminClients.edit.field_two_factor_mode_on'] = 'Desactivar la autenticación de dos factores (actualmente activada)';
$lang['AdminClients.edit.field_taxexempt'] = 'Exento de impuestos';
$lang['AdminClients.edit.field_taxid'] = 'Número de identificación fiscal/VATIN';
$lang['AdminClients.edit.field_preferredcurrency'] = 'Moneda preferente';
$lang['AdminClients.edit.field_invoiceaddress'] = 'Dirección de facturación';
$lang['AdminClients.edit.field_language'] = 'Idioma';
$lang['AdminClients.edit.field_clientgroup'] = 'Grupo de clientes';
$lang['AdminClients.edit.field_receive_email_marketing'] = 'Suscripción a correos electrónicos de marketing';
$lang['AdminClients.edit.field_clientsubmit'] = 'Modificar cliente';
$lang['AdminClients.accountachinfo.heading_account'] = 'Información sobre la cuenta bancaria';
$lang['AdminClients.accountachinfo.field_type'] = 'Tipo';
$lang['AdminClients.accountachinfo.field_accountnum'] = 'Número de cuenta';
$lang['AdminClients.accountachinfo.field_routingnum'] = 'Número de ruta';
$lang['AdminClients.accountachinfo.field_savedetails'] = 'Guardar cuenta';
$lang['AdminClients.accountachinfo.text_showaccount'] = 'Mostrar cuenta';
$lang['AdminClients.accountccinfo.heading_cc'] = 'Información sobre la tarjeta de crédito';
$lang['AdminClients.accountccinfo.field_number'] = 'Número';
$lang['AdminClients.accountccinfo.field_security'] = 'Código de seguridad';
$lang['AdminClients.accountccinfo.field_expiration'] = 'Fecha de expiración';
$lang['AdminClients.accountccinfo.field_savedetails'] = 'Guardar cuenta';
$lang['AdminClients.accountccinfo.text_showcard'] = 'Mostrar tarjeta';
$lang['AdminClients.accountccinfo.tooltip_code'] = 'El código de seguridad de 3 ó 4 dígitos, que suele figurar en el reverso de la tarjeta.';
$lang['AdminClients.accounttypes.heading_types'] = 'Formas de pago aceptadas';
$lang['AdminClients.accounttypes.submit_settings'] = 'Actualizar ajustes';
$lang['AdminClients.accounttypes.cancel'] = 'Cancelar';
$lang['AdminClients.accountcontactinfo.heading_contact'] = 'Información de contacto';
$lang['AdminClients.accountcontactinfo.field_contact_id'] = 'Copiar información de contacto de';
$lang['AdminClients.accountcontactinfo.field_first_name'] = 'Nombre';
$lang['AdminClients.accountcontactinfo.field_last_name'] = 'Apellido';
$lang['AdminClients.accountcontactinfo.field_address1'] = 'Dirección 1';
$lang['AdminClients.accountcontactinfo.field_address2'] = 'Dirección 2';
$lang['AdminClients.accountcontactinfo.field_city'] = 'Ciudad';
$lang['AdminClients.accountcontactinfo.field_country'] = 'País';
$lang['AdminClients.accountcontactinfo.field_state'] = 'Estado';
$lang['AdminClients.accountcontactinfo.field_zip'] = 'Código postal';
$lang['AdminClients.phones.categorylink_number'] = 'Añadir número adicional';
$lang['AdminClients.phones.rowheading_number'] = 'Números de teléfono';
$lang['AdminClients.phones.text_remove'] = 'Eliminar';
$lang['AdminClients.phones.field_phonetype'] = 'Tipo';
$lang['AdminClients.phones.field_phonelocation'] = 'Ubicación';
$lang['AdminClients.phones.field_phonenumber'] = 'Número';
$lang['AdminClients.editcontact.page_title'] = 'Cliente #%1$s Modificar Contacto';
$lang['AdminClients.editcontact.boxtitle_editcontact'] = 'Modificar contacto';
$lang['AdminClients.editcontact.heading_contact'] = 'Información de contacto';
$lang['AdminClients.editcontact.heading_authentication'] = 'Autenticación';
$lang['AdminClients.editcontact.field_enable_login'] = 'Activar inicio de sesión';
$lang['AdminClients.editcontact.field_username'] = 'Nombre de usuario';
$lang['AdminClients.editcontact.field_newpassword'] = 'Contraseña';
$lang['AdminClients.editcontact.text_generate_password'] = 'Generar contraseña';
$lang['AdminClients.editcontact.field_two_factor_mode'] = 'Autenticación de dos factores';
$lang['AdminClients.editcontact.field_two_factor_mode_off'] = 'No activado';
$lang['AdminClients.editcontact.field_two_factor_mode_on'] = 'Desactivar la autenticación de dos factores (actualmente activada)';
$lang['AdminClients.editcontact.field_permissions'] = 'Permisos';
$lang['AdminClients.editcontact.heading_settings'] = 'Ajustes adicionales';
$lang['AdminClients.editcontact.field_firstname'] = 'Nombre';
$lang['AdminClients.editcontact.field_lastname'] = 'Apellido';
$lang['AdminClients.editcontact.field_company'] = 'Empresa/Org.';
$lang['AdminClients.editcontact.field_title'] = 'Título';
$lang['AdminClients.editcontact.field_address1'] = 'Dirección 1';
$lang['AdminClients.editcontact.field_address2'] = 'Dirección 2';
$lang['AdminClients.editcontact.field_city'] = 'Ciudad';
$lang['AdminClients.editcontact.field_state'] = 'Estado/Provincia';
$lang['AdminClients.editcontact.field_zip'] = 'Código postal';
$lang['AdminClients.editcontact.field_country'] = 'País';
$lang['AdminClients.editcontact.field_email'] = 'Correo electrónico';
$lang['AdminClients.editcontact.field_contacttype'] = 'Tipo de contacto';
$lang['AdminClients.editcontact.field_contactsubmit'] = 'Modificar contacto';
$lang['AdminClients.editcontact.field_deletecontact'] = 'Borrar contacto';
$lang['AdminClients.editcontact.confirm_delete'] = '¿Estás seguro de que quieres eliminar este contacto?';
$lang['AdminClients.editinvoice.page_title'] = 'Cliente #%1$s Editar factura #%2$s';
$lang['AdminClients.editinvoice.boxtitle_editinvoice'] = 'Editar factura [%1$s]';
$lang['AdminClients.editinvoice.boxtitle_editdraft'] = 'Editar borrador de factura [%1$s]';
$lang['AdminClients.editinvoice.heading_description'] = 'Descripción';
$lang['AdminClients.editinvoice.heading_quantity'] = 'Cantidad';
$lang['AdminClients.editinvoice.heading_unitcost'] = 'Coste unitario';
$lang['AdminClients.editinvoice.heading_tax'] = 'Impuesto';
$lang['AdminClients.editinvoice.heading_options'] = 'Opciones';
$lang['AdminClients.editinvoice.heading_term'] = 'Plazo';
$lang['AdminClients.editinvoice.heading_period'] = 'Periodo';
$lang['AdminClients.editinvoice.heading_duration'] = 'Duración';
$lang['AdminClients.editinvoice.heading_nextbilldate'] = 'Próxima fecha de renovación';
$lang['AdminClients.editinvoice.option_add'] = 'Añadir';
$lang['AdminClients.editinvoice.option_delete'] = 'Borrar';
$lang['AdminClients.editinvoice.field_datebilled'] = 'Fecha de facturación:';
$lang['AdminClients.editinvoice.field_datedue'] = 'Fecha de vencimiento:';
$lang['AdminClients.editinvoice.field_invoicedelivery'] = 'Entrega de facturas:';
$lang['AdminClients.editinvoice.field_autodebit'] = 'Débito automático:';
$lang['AdminClients.editinvoice.field_autodebit_text'] = 'Permitir el cargo automático de esta factura';
$lang['AdminClients.editinvoice.tooltip_autodebit'] = 'Al marcar esta casilla, se habilitará el débito automático de esta factura si el débito automático está habilitado y disponible para el cliente.';
$lang['AdminClients.editinvoice.field_recache'] = 'Recache:';
$lang['AdminClients.editinvoice.field_recache_text'] = 'Guardar esta factura en caché al actualizarla';
$lang['AdminClients.editinvoice.tooltip_recache'] = 'Al marcar esta casilla se sustituirá la factura almacenada en caché por los datos actualizados al guardarla.';
$lang['AdminClients.editinvoice.field_currency'] = 'Moneda';
$lang['AdminClients.editinvoice.field_duration_indefinitely'] = 'Indefinidamente';
$lang['AdminClients.editinvoice.field_duration_times'] = 'número de veces';
$lang['AdminClients.editinvoice.field_notepublic'] = 'Nota pública:';
$lang['AdminClients.editinvoice.field_noteprivate'] = 'Nota privada:';
$lang['AdminClients.editinvoice.field_invoicesubmit'] = 'Modificar factura';
$lang['AdminClients.editinvoice.field_invoicedvoid'] = 'Factura nula';
$lang['AdminClients.editinvoice.field_invoicecreate'] = 'Cree';
$lang['AdminClients.editinvoice.field_invoicesavedraft'] = 'Guardar borrador';
$lang['AdminClients.editinvoice.field_invoiceunvoid'] = 'Evitar y modificar';
$lang['AdminClients.editinvoice.field_invoicedelete'] = 'Borrar factura';
$lang['AdminClients.editinvoice.section_recurringinvoice'] = 'Factura recurrente';
$lang['AdminClients.editinvoice.section_notes'] = 'Notas';
$lang['AdminClients.editinvoice.price_subtotal'] = 'Subtotal:';
$lang['AdminClients.editinvoice.auto_save_saving'] = 'Guardando borrador...';
$lang['AdminClients.editinvoice.auto_save_saved'] = 'Borrador guardado';
$lang['AdminClients.editinvoice.auto_save_error'] = 'No se ha podido autoguardar el borrador';
$lang['AdminClients.editinvoice.field_continue'] = 'Continúe en';
$lang['AdminClients.editinvoice.field_cancel'] = 'Cancelar';
$lang['AdminClients.editrecurinvoice.page_title'] = 'Cliente #%1$s Editar factura periódica #%2$s';
$lang['AdminClients.editrecurinvoice.boxtitle_editinvoice'] = 'Editar factura periódica [%1$s]';
$lang['AdminClients.editinvoice.confirm_deleterecur'] = 'Esto eliminará permanentemente esta factura periódica. No se generarán más facturas utilizando esta factura periódica. ¿Está seguro de que desea eliminarla?';
$lang['AdminClients.edittransaction.page_title'] = 'Cliente #%1$s Editar transacción';
$lang['AdminClients.edittransaction.boxtitle_edittransaction'] = 'Editar transacción';
$lang['AdminClients.edittransaction.heading_type'] = 'Tipo';
$lang['AdminClients.edittransaction.heading_amount'] = 'Importe';
$lang['AdminClients.edittransaction.heading_credited'] = 'Acreditado';
$lang['AdminClients.edittransaction.heading_applied'] = 'Aplicada';
$lang['AdminClients.edittransaction.heading_number'] = 'Número';
$lang['AdminClients.edittransaction.heading_status'] = 'Estado';
$lang['AdminClients.edittransaction.heading_date'] = 'Fecha';
$lang['AdminClients.edittransaction.subheading_invoice'] = 'Factura #';
$lang['AdminClients.edittransaction.subheading_amount'] = 'Importe';
$lang['AdminClients.edittransaction.subheading_appliedon'] = 'Aplicado en';
$lang['AdminClients.edittransaction.subheading_options'] = 'Opciones';
$lang['AdminClients.edittransaction.field_status'] = 'Estado';
$lang['AdminClients.edittransaction.field_processremotely'] = 'Procesar este cambio de estado con la pasarela de pago (%1$s)';
$lang['AdminClients.edittransaction.field_submit'] = 'Modificar transacción';
$lang['AdminClients.edittransaction.applied_no_results'] = 'Esta transacción no se ha aplicado a ninguna factura.';
$lang['AdminClients.edittransaction.option_unapply'] = 'Desaplicar';
$lang['AdminClients.edittransaction.confirm_unapply'] = '¿Realmente anular esta transacción de la factura seleccionada?';
$lang['AdminClients.email.page_title'] = 'Cliente #%1$s Cliente de correo electrónico';
$lang['AdminClients.email.boxtitle_emailclient'] = 'Cliente de correo electrónico';
$lang['AdminClients.email.field_recipient'] = 'Destinatario';
$lang['AdminClients.email.field_fromname'] = 'De Nombre';
$lang['AdminClients.email.field_from'] = 'Del correo electrónico';
$lang['AdminClients.email.field_subject'] = 'Asunto';
$lang['AdminClients.email.field_message'] = 'Texto';
$lang['AdminClients.email.field_messagehtml'] = 'HTML';
$lang['AdminClients.email.field_emailsubmit'] = 'Enviar correo electrónico';
$lang['AdminClients.emails.page_title'] = 'Cliente #%1$s Mail Log';
$lang['AdminClients.emails.boxtitle_maillog'] = 'Registro de correo';
$lang['AdminClients.emails.heading_date'] = 'Fecha';
$lang['AdminClients.emails.heading_subject'] = 'Asunto';
$lang['AdminClients.emails.heading_summary'] = 'Resumen';
$lang['AdminClients.emails.text_to'] = 'A';
$lang['AdminClients.emails.text_cc'] = 'CC';
$lang['AdminClients.emails.text_from'] = 'En';
$lang['AdminClients.emails.text_resend'] = 'Vuelva a enviar';
$lang['AdminClients.emails.no_results'] = 'No hay correos electrónicos.';
$lang['AdminClients.passwordreset.page_title'] = 'Cliente #%1$s Restablecer contraseña';
$lang['AdminClients.passwordreset.boxtitle_passwordreset'] = 'Enviar restablecimiento de contraseña';
$lang['AdminClients.passwordreset.field_contact_id'] = 'Póngase en contacto con';
$lang['AdminClients.passwordreset.contact_id_name'] = '%1$s %2$s (%3$s) %4$s';
$lang['AdminClients.passwordreset.field_submit'] = 'Enviar correo electrónico';
$lang['AdminClients.invoices.page_title'] = 'Cliente #%1$s Facturas';
$lang['AdminClients.invoices.boxtitle_invoices'] = 'Facturas';
$lang['AdminClients.invoices.heading_invoice'] = 'Factura #';
$lang['AdminClients.invoices.heading_recurinvoice'] = 'Recurrente';
$lang['AdminClients.invoices.heading_amount'] = 'Importe';
$lang['AdminClients.invoices.heading_paid'] = 'Pagado';
$lang['AdminClients.invoices.heading_due'] = 'Debido';
$lang['AdminClients.invoices.heading_dateclosed'] = 'Fecha de cierre';
$lang['AdminClients.invoices.heading_datebilled'] = 'Fecha de facturación';
$lang['AdminClients.invoices.heading_datedue'] = 'Fecha de vencimiento';
$lang['AdminClients.invoices.heading_status'] = 'Estado';
$lang['AdminClients.invoices.heading_options'] = 'Opciones';
$lang['AdminClients.invoices.heading_term'] = 'Plazo';
$lang['AdminClients.invoices.heading_duration'] = 'Duración';
$lang['AdminClients.invoices.heading_count'] = 'Cuenta';
$lang['AdminClients.invoices.category_open'] = 'Abrir';
$lang['AdminClients.invoices.category_drafts'] = 'Borradores';
$lang['AdminClients.invoices.category_closed'] = 'Cerrado';
$lang['AdminClients.invoices.category_voided'] = 'Anulado';
$lang['AdminClients.invoices.category_recurring'] = 'Recurrente';
$lang['AdminClients.invoices.category_pending'] = 'Pendiente';
$lang['AdminClients.invoices.categorylink_createinvoice'] = 'Crear factura';
$lang['AdminClients.invoices.headingexpand_paymenttype'] = 'Tipo de pago';
$lang['AdminClients.invoices.headingexpand_amount'] = 'Importe';
$lang['AdminClients.invoices.headingexpand_applied'] = 'Aplicada';
$lang['AdminClients.invoices.headingexpand_appliedon'] = 'Aplicado en';
$lang['AdminClients.invoices.headingexpand_options'] = 'Opciones';
$lang['AdminClients.invoices.status_sent'] = 'Enviado';
$lang['AdminClients.invoices.status_unsent'] = 'No enviado';
$lang['AdminClients.invoices.option_edit'] = 'Editar';
$lang['AdminClients.invoices.option_view'] = 'Ver';
$lang['AdminClients.invoices.option_pay'] = 'Pagar';
$lang['AdminClients.invoices.option_delete'] = 'Borrar';
$lang['AdminClients.invoices.confirm_delete'] = '¿Está seguro de que desea eliminar este borrador de factura?';
$lang['AdminClients.invoices.optionexpand_edit'] = 'Editar';
$lang['AdminClients.invoices.action_deliver'] = 'Entregar vía %1$s';
$lang['AdminClients.invoices.action_void'] = 'Facturas nulas';
$lang['AdminClients.invoices.field_invoicesubmit'] = 'Enviar';
$lang['AdminClients.invoices.field_continue'] = 'Continuar';
$lang['AdminClients.invoices.field_cancel'] = 'Cancelar';
$lang['AdminClients.invoices.no_results'] = 'No hay facturas con este estado.';
$lang['AdminClients.invoices.applied_no_results'] = 'Esta factura no tiene ninguna transacción aplicada.';
$lang['AdminClients.invoices.subtotal_w_tax'] = '%1$s +impuestos';
$lang['AdminClients.invoices.term_day'] = '%1$s día';
$lang['AdminClients.invoices.term_week'] = '%1$s semana';
$lang['AdminClients.invoices.term_month'] = '%1$s mes';
$lang['AdminClients.invoices.term_year'] = '%1$s año';
$lang['AdminClients.invoices.term_day_plural'] = '%1$s días';
$lang['AdminClients.invoices.term_week_plural'] = '%1$s semanas';
$lang['AdminClients.invoices.term_month_plural'] = '%1$s meses';
$lang['AdminClients.invoices.term_year_plural'] = '%1$s años';
$lang['AdminClients.invoices.duration_finite'] = '%1$s veces';
$lang['AdminClients.invoices.duration_infinite'] = '∞';
$lang['AdminClients.quotations.page_title'] = 'Cotizaciones de facturación';
$lang['AdminClients.quotations.boxtitle_quotations'] = 'Citas';
$lang['AdminClients.quotations.heading_quotation'] = 'Cita';
$lang['AdminClients.quotations.heading_client'] = 'Cliente';
$lang['AdminClients.quotations.heading_title'] = 'Título';
$lang['AdminClients.quotations.heading_staff'] = 'Citado por';
$lang['AdminClients.quotations.heading_subtotal'] = 'Subtotal';
$lang['AdminClients.quotations.heading_total'] = 'Importe';
$lang['AdminClients.quotations.heading_date_created'] = 'Fecha de creación';
$lang['AdminClients.quotations.heading_date_expires'] = 'Fecha de expiración';
$lang['AdminClients.quotations.heading_options'] = 'Opciones';
$lang['AdminClients.quotations.category_draft'] = 'Borrador';
$lang['AdminClients.quotations.category_approved'] = 'Aprobado';
$lang['AdminClients.quotations.category_pending'] = 'Pendiente';
$lang['AdminClients.quotations.category_expired'] = 'Caducado';
$lang['AdminClients.quotations.category_invoiced'] = 'Facturado';
$lang['AdminClients.quotations.category_dead'] = 'Muerto';
$lang['AdminClients.quotations.category_lost'] = 'Perdido';
$lang['AdminClients.quotations.option_edit'] = 'Editar';
$lang['AdminClients.quotations.option_view'] = 'Ver';
$lang['AdminClients.quotations.option_invoice'] = 'Crear factura';
$lang['AdminClients.quotations.option_approve'] = 'Aprobar';
$lang['AdminClients.quotations.confirm_approve'] = '¿Está seguro de que desea aprobar esta cita?';
$lang['AdminClients.quotations.categorylink_createquotation'] = 'Crear presupuesto';
$lang['AdminClients.quotations.field_quotationsubmit'] = 'Enviar';
$lang['AdminClients.quotations.action.email'] = 'Entregar por correo electrónico';
$lang['AdminClients.quotations.action.status'] = 'Cambiar estado';
$lang['AdminClients.quotations.no_results'] = 'No hay cotizaciones con este estado.';
$lang['AdminClients.quotationinvoices.headingexpand_invoice'] = 'Factura #';
$lang['AdminClients.quotationinvoices.headingexpand_amount'] = 'Importe';
$lang['AdminClients.quotationinvoices.headingexpand_paid'] = 'Pagado';
$lang['AdminClients.quotationinvoices.headingexpand_date_billed'] = 'Fecha de facturación';
$lang['AdminClients.quotationinvoices.headingexpand_options'] = 'Opciones';
$lang['AdminClients.quotationinvoices.option_view'] = 'Ver';
$lang['AdminClients.quotationinvoices.invoices_no_results'] = 'No hay facturas asociadas a este presupuesto.';
$lang['AdminClients.merge.page_title'] = 'Cliente #%1$s Fusionar clientes';
$lang['AdminClients.merge.boxtitle_merge'] = 'Fusionar clientes';
$lang['AdminClients.merge.field_clientid'] = 'ID de cliente a fusionar';
$lang['AdminClients.merge.field_mergefrom'] = 'Fusionar cliente de';
$lang['AdminClients.merge.field_btoa'] = 'B a A';
$lang['AdminClients.merge.field_atob'] = 'De A a B';
$lang['AdminClients.merge.field_password'] = 'Contraseña de administrador';
$lang['AdminClients.merge.field_mergesubmit'] = 'Fusionar clientes';
$lang['AdminClients.stickynotes.date_separator'] = ':';
$lang['AdminClients.stickynotes.text_unstick'] = 'Despegar';
$lang['AdminClients.stickynotes.text_more'] = 'Ver más';
$lang['AdminClients.stickynotes.text_less'] = 'Mostrar menos';
$lang['AdminClients.notes.page_title'] = 'Cliente #%1$s Notas';
$lang['AdminClients.notes.boxtitle_notes'] = 'Notas';
$lang['AdminClients.notes.heading_title'] = 'Resumen';
$lang['AdminClients.notes.heading_dateupdated'] = 'Fecha de actualización';
$lang['AdminClients.notes.heading_options'] = 'Opciones';
$lang['AdminClients.notes.heading_staff'] = 'Creado por';
$lang['AdminClients.notes.heading_dateadded'] = 'Fecha de adición';
$lang['AdminClients.notes.by_system'] = 'Sistema';
$lang['AdminClients.notes.categorylink_create'] = 'Crear nota';
$lang['AdminClients.notes.option_edit'] = 'Editar';
$lang['AdminClients.notes.option_delete'] = 'Borrar';
$lang['AdminClients.notes.confirm_delete'] = '¿Seguro que quieres borrar esta nota?';
$lang['AdminClients.notes.no_results'] = 'No hay notas.';
$lang['AdminClients.!notes.stickied'] = 'Marque esta casilla para mostrar esta nota en la página de perfil del cliente.';
$lang['AdminClients.addnote.page_title'] = 'Cliente #%1$s Crear nota';
$lang['AdminClients.addnote.boxtitle_createnote'] = 'Crear nota';
$lang['AdminClients.addnote.field_title'] = 'Resumen';
$lang['AdminClients.addnote.field_description'] = 'Detalles';
$lang['AdminClients.addnote.field_stickied'] = 'Pegar esta nota';
$lang['AdminClients.addnote.field_notesubmit'] = 'Crear nota';
$lang['AdminClients.editnote.page_title'] = 'Cliente #%1$s Editar Nota';
$lang['AdminClients.editnote.boxtitle_editnote'] = 'Editar Nota';
$lang['AdminClients.editnote.field_title'] = 'Resumen';
$lang['AdminClients.editnote.field_description'] = 'Detalles';
$lang['AdminClients.editnote.field_stickied'] = 'Pegar esta nota';
$lang['AdminClients.editnote.field_notesubmit'] = 'Editar Nota';
$lang['AdminClients.addservice.status.active'] = 'Activo';
$lang['AdminClients.addservice.status.inactive'] = 'Inactivo';
$lang['AdminClients.addservice.status.restricted'] = 'Restringido';
$lang['AdminClients.addservice.page_title'] = 'Cliente #%1$s Añadir servicio';
$lang['AdminClients.addservice.boxtitle_addservice'] = 'Añadir servicio: %1$s';
$lang['AdminClients.addservice.field_package'] = 'Paquete';
$lang['AdminClients.addservice.field_continue'] = 'Continuar';
$lang['AdminClients.addservice.auto_choose'] = '-- Elige Automáticamente --';
$lang['AdminClients.addservice.term_onetime'] = 'Una sola vez - %3$s';
$lang['AdminClients.addservice.term'] = '%1$s %2$s - %3$s';
$lang['AdminClients.addservice.term_recurring'] = '%1$s %2$s - %3$s (renueva @ %4$s)';
$lang['AdminClients.addservice.term_dated'] = '%1$s %2$s - %3$s (%4$s - %5$s)';
$lang['AdminClients.addservice_basic.basic_heading'] = 'Opciones básicas';
$lang['AdminClients.addservice_basic.field_invoice_method'] = 'Método de facturación';
$lang['AdminClients.addservice_basic.field_invoice_method_create'] = 'Crear factura';
$lang['AdminClients.addservice_basic.field_invoice_method_append'] = 'Añadir a la factura';
$lang['AdminClients.addservice_basic.field_invoice_method_dont'] = 'No facturar';
$lang['AdminClients.addservice_basic.field_term'] = 'Plazo';
$lang['AdminClients.addservice_basic.field_status'] = 'Estado';
$lang['AdminClients.addservice_basic.field_notify_order'] = 'Enviar correo electrónico de confirmación del pedido cuando se active';
$lang['AdminClients.addservice_basic.field_use_module'] = 'Provisión que utiliza el módulo %1$s cuando se activa';
$lang['AdminClients.addservice_basic.module_heading'] = '%1$s Opciones';
$lang['AdminClients.addservice_basic.addons_heading'] = 'Complementos';
$lang['AdminClients.addservice_basic.field_default_addon'] = 'Ninguno';
$lang['AdminClients.addservice_basic.field_continue'] = 'Continuar';
$lang['AdminClients.addservice_addon.module_heading'] = '%1$s Opciones';
$lang['AdminClients.addservice_addon.basic_heading'] = 'Opciones básicas';
$lang['AdminClients.addservice_addon.field_term'] = 'Plazo';
$lang['AdminClients.addservice_confirm.field_invoice_method'] = 'Método de facturación:';
$lang['AdminClients.addservice_confirm.field_invoice_method_create'] = 'Crear factura';
$lang['AdminClients.addservice_confirm.field_invoice_method_append'] = 'Añadir a factura %1$s';
$lang['AdminClients.addservice_confirm.field_invoice_method_none'] = 'No facturar';
$lang['AdminClients.addservice_confirm.field_notify_order'] = 'Enviar correo electrónico de confirmación de pedido:';
$lang['AdminClients.addservice_confirm.field_notify_order_true'] = 'Sí';
$lang['AdminClients.addservice_confirm.field_notify_order_false'] = 'No';
$lang['AdminClients.addservice_confirm.field_status'] = 'Estado:';
$lang['AdminClients.addservice_confirm.description'] = 'Descripción';
$lang['AdminClients.addservice_confirm.qty'] = 'Cantidad';
$lang['AdminClients.addservice_confirm.price'] = 'Precio';
$lang['AdminClients.addservice_confirm.subtotal'] = 'Subtotal:';
$lang['AdminClients.addservice_confirm.setup_fee'] = 'Tasa de establecimiento:';
$lang['AdminClients.addservice_confirm.discount'] = 'Descuento:';
$lang['AdminClients.addservice_confirm.field_coupon_code'] = 'Código de cupón';
$lang['AdminClients.addservice_confirm.field_update_coupon'] = 'Actualización';
$lang['AdminClients.addservice_confirm.field_add'] = 'Añadir servicio';
$lang['AdminClients.addservice_confirm.field_edit'] = 'Editar';
$lang['AdminClients.editservice.page_title'] = 'Cliente #%1$s Gestionar servicio';
$lang['AdminClients.editservice.boxtitle_editservice'] = 'Gestionar servicio: %1$s - %2$s';
$lang['AdminClients.editservice.tab_basic'] = 'Opciones básicas';
$lang['AdminClients.editservice.tab_addon'] = 'Complementos (%1$s)';
$lang['AdminClients.editservice.suspension_reason_note'] = 'Motivo de la suspensión: %1$s';
$lang['AdminClients.editservice.cancellation_reason_note'] = 'Motivo de la cancelación: %1$s';
$lang['AdminClients.editservice.service_heading'] = 'Información de servicio';
$lang['AdminClients.editservice.text_package_name'] = 'Nombre del paquete:';
$lang['AdminClients.editservice.text_label'] = 'Etiqueta:';
$lang['AdminClients.editservice.text_qty'] = 'Cantidad:';
$lang['AdminClients.editservice.text_term'] = 'Plazo:';
$lang['AdminClients.editservice.text_status'] = 'Estado:';
$lang['AdminClients.editservice.text_date_added'] = 'Fecha de creación:';
$lang['AdminClients.editservice.text_date_renews'] = 'Fecha de renovación:';
$lang['AdminClients.editservice.text_date_suspended'] = 'Fecha de suspensión:';
$lang['AdminClients.editservice.text_date_canceled'] = 'Fecha de cancelación prevista:';
$lang['AdminClients.editservice.text_recurring_coupon'] = 'Cupón recurrente:';
$lang['AdminClients.editservice.text_coupon_percent'] = '%1$s (%2$s%%)';
$lang['AdminClients.editservice.text_coupon_amount'] = '%1$s (%2$s)';
$lang['AdminClients.editservice.text_renewal_price'] = 'Precio de renovación:';
$lang['AdminClients.editservice.text_no_addons'] = 'No hay complementos disponibles.';
$lang['AdminClients.editservice.text_children'] = 'Este servicio está asociado a uno o varios servicios hijos. Al cancelar este servicio, se cancelarán también todos los servicios hijos.';
$lang['AdminClients.editservice.action_heading'] = 'Acciones';
$lang['AdminClients.editservice.package_heading'] = 'Actualizar/desactualizar';
$lang['AdminClients.editservice.module_heading'] = '%1$s Opciones';
$lang['AdminClients.editservice.addon_heading'] = 'Complementos disponibles';
$lang['AdminClients.editservice.field_prorate'] = 'Prorratear';
$lang['AdminClients.editservice.tooltip_prorate'] = 'Si se prorratea, se generará una factura para cubrir la diferencia de precio entre el precio actual y el nuevo. Sin embargo, el prorrateo no puede producirse si se establece un precio de anulación.';
$lang['AdminClients.editservice.tooltip_prorate_renewal'] = 'Se generará una factura para cubrir la diferencia de precio entre la fecha de renovación actual y la nueva fecha de renovación.';
$lang['AdminClients.editservice.field_use_module'] = 'Módulo de uso';
$lang['AdminClients.editservice.field_notify_order'] = 'Enviar correo electrónico de confirmación del pedido';
$lang['AdminClients.editservice.field_module_save'] = 'Guardar';
$lang['AdminClients.editservice.field_module_activate'] = 'Activar';
$lang['AdminClients.editservice.field_add_addon'] = 'Añadir servicio';
$lang['AdminClients.editservice.action.field_action'] = 'Acción';
$lang['AdminClients.editservice.action.field_notify_cancel'] = 'Enviar correo electrónico de cancelación de servicio';
$lang['AdminClients.editservice.action.field_cancel_term'] = 'Fin de plazo';
$lang['AdminClients.editservice.action.field_cancel_term_date'] = 'Fin de plazo (%1$s)';
$lang['AdminClients.editservice.action.field_cancel_date'] = 'Fecha específica';
$lang['AdminClients.editservice.action.field_cancel_none'] = 'No cancelar';
$lang['AdminClients.editservice.action.field_date_renews'] = 'Fecha Renueva';
$lang['AdminClients.editservice.action.field_suspension_reason'] = 'Motivo de la suspensión';
$lang['AdminClients.editservice.action.field_cancellation_reason'] = 'Motivo de la cancelación';
$lang['AdminClients.editservice.action.field_coupon_code'] = 'Código de cupón';
$lang['AdminClients.editservice.package.field_pricing'] = 'Paquete/Plazo';
$lang['AdminClients.editservice.field_price_override'] = 'Precio de anulación';
$lang['AdminClients.editservice.field_override_price'] = 'Precio';
$lang['AdminClients.editservice.field_current_coupon_code'] = 'Código de cupón actual';
$lang['AdminClients.editservice.field_new_coupon_code'] = 'Nuevo código de cupón';
$lang['AdminClients.editservice.tooltip_coupon_code'] = 'El cupón debe ser válido y se aplicará cuando se renueve el servicio.';
$lang['AdminClients.serviceinfo.no_results'] = 'Este servicio no tiene detalles.';
$lang['AdminClients.serviceinfo.cancellation_reason'] = 'Motivo de la cancelación: %1$s';
$lang['AdminClients.makepayment.page_title'] = 'Cliente #%1$s Realizar pago';
$lang['AdminClients.makepayment.boxtitle_makepayment'] = 'Realizar el pago';
$lang['AdminClients.makepayment.heading_paymentaccount'] = 'Financiación';
$lang['AdminClients.makepayment.field_paymentaccount'] = '%1$s %2$s - %3$s x%4$s';
$lang['AdminClients.makepayment.field_paymentaccount_autodebit'] = '(Cargo automático) %1$s %2$s - %3$s x%4$s';
$lang['AdminClients.makepayment.field_paymentaccount_ach'] = 'Cuentas ACH';
$lang['AdminClients.makepayment.field_paymentaccount_cc'] = 'Cuentas de tarjeta de crédito';
$lang['AdminClients.makepayment.field_submit'] = 'Continúe en';
$lang['AdminClients.makepayment.field_useaccount'] = 'Utilizar cuenta de pago';
$lang['AdminClients.makepayment.field_newdetails'] = 'Nuevos datos de pago';
$lang['AdminClients.makepayment.boxtitle_makepaymentamount'] = 'Realizar el pago';
$lang['AdminClients.makepayment.record_invoice'] = 'Registrar el pago de la factura #%1$s, en lugar de';
$lang['AdminClients.makepayment.record_payment'] = 'Registrar pago en su lugar';
$lang['AdminClients.makepaymentamount.heading_invoices'] = 'Selección de facturas';
$lang['AdminClients.makepaymentamount.field_submit'] = 'Revisar y confirmar';
$lang['AdminClients.makepaymentamount.field_receipt'] = 'Recibo por correo electrónico';
$lang['AdminClients.makepaymentamount.field_credit'] = 'Otro importe de pago';
$lang['AdminClients.makepaymentamount.field_currency'] = 'Moneda';
$lang['AdminClients.makepaymentamount.text_amount'] = 'Importe a pagar';
$lang['AdminClients.makepaymentamount.text_due'] = 'Importe debido';
$lang['AdminClients.makepaymentamount.text_invoice'] = 'Factura #';
$lang['AdminClients.makepaymentamount.text_datedue'] = 'Fecha de vencimiento';
$lang['AdminClients.makepaymentamount.no_results'] = 'No hay facturas en esta moneda.';
$lang['AdminClients.makepaymentconfirm.boxtitle_makepaymentconfirm'] = 'Confirmar pago';
$lang['AdminClients.makepaymentconfirm.field_submit'] = 'Enviar pago';
$lang['AdminClients.makepaymentconfirm.field_edit'] = 'Editar pago';
$lang['AdminClients.makepaymentconfirm.text_amount'] = 'Importe a solicitar';
$lang['AdminClients.makepaymentconfirm.text_due'] = 'Importe debido';
$lang['AdminClients.makepaymentconfirm.text_invoice'] = 'Factura #';
$lang['AdminClients.makepaymentconfirm.text_datedue'] = 'Fecha de vencimiento';
$lang['AdminClients.makepaymentconfirm.account_info'] = '%1$s (%2$s) terminando en %3$s';
$lang['AdminClients.makepaymentconfirm.account_info_type'] = '%1$s';
$lang['AdminClients.makepaymentconfirm.account_exp'] = 'caduca %1$s';
$lang['AdminClients.makepaymentconfirm.total'] = 'Total:';
$lang['AdminClients.makepaymentconfirm.payment_details'] = 'Datos de pago';
$lang['AdminClients.makepaymentconfirm.email_receipt'] = 'Recibo por correo electrónico';
$lang['AdminClients.makepaymentconfirm.email_receipt_yes'] = 'Sí';
$lang['AdminClients.makepaymentconfirm.email_receipt_no'] = 'No';
$lang['AdminClients.recordpaymentconfirm.trans_info_credit'] = 'Solicitar crédito';
$lang['AdminClients.makepaymentconfirm.trans_info_detailed'] = '%1$s Pago #%2$s';
$lang['AdminClients.makepaymentconfirm.trans_info'] = '%1$s Pago';
$lang['AdminClients.recordpayment.page_title'] = 'Cliente #%1$s Registrar pago';
$lang['AdminClients.recordpayment.boxtitle_recordpayment'] = 'Registre el pago';
$lang['AdminClients.recordpayment.field_receipt'] = 'Recibo por correo electrónico';
$lang['AdminClients.recordpayment.field_amount'] = 'Importe del pago';
$lang['AdminClients.recordpayment.field_payment_type_record'] = 'Registrar nuevo pago';
$lang['AdminClients.recordpayment.field_payment_type_credit'] = 'Solicitar crédito (%1$s)';
$lang['AdminClients.recordpayment.field_currency'] = 'Moneda';
$lang['AdminClients.recordpayment.field_status'] = 'Estado';
$lang['AdminClients.recordpayment.field_datereceived'] = 'Fecha de recepción';
$lang['AdminClients.recordpayment.field_transaction_id'] = 'Cheque/DNI';
$lang['AdminClients.recordpayment.field_transactiontype'] = 'Tipo de pago';
$lang['AdminClients.recordpayment.field_gateway_id'] = 'Pasarela de pagos';
$lang['AdminClients.recordpayment.field_submit'] = 'Continuar';
$lang['AdminClients.recordpayment.text_datereceived'] = 'Fecha de recepción';
$lang['AdminClients.recordpayment.gateway_none'] = 'Ninguno';
$lang['AdminClients.recordpaymentconfirm.boxtitle_recordconfirm'] = 'Confirmar pago';
$lang['AdminClients.recordpaymentconfirm.total'] = 'Total:';
$lang['AdminClients.recordpaymentconfirm.payment_details'] = 'Datos de pago';
$lang['AdminClients.recordpaymentconfirm.email_receipt'] = 'Recibo por correo electrónico';
$lang['AdminClients.recordpaymentconfirm.email_receipt_yes'] = 'Sí';
$lang['AdminClients.recordpaymentconfirm.email_receipt_no'] = 'No';
$lang['AdminClients.recordpaymentconfirm.trans_info_detailed'] = '%1$s Pago #%2$s';
$lang['AdminClients.recordpaymentconfirm.trans_info'] = '%1$s Pago';
$lang['AdminClients.recordpaymentconfirm.field_submit'] = 'Enviar pago';
$lang['AdminClients.recordpaymentconfirm.field_edit'] = 'Editar pago';
$lang['AdminClients.setcontactview.text_none'] = 'Ninguno';
$lang['AdminClients.services.page_title'] = 'Cliente #%1$s Servicios';
$lang['AdminClients.services.boxtitle_services'] = 'Servicios';
$lang['AdminClients.services.heading_addons'] = 'Complementos';
$lang['AdminClients.services.heading_status'] = 'Estado';
$lang['AdminClients.services.heading_package'] = 'Paquete';
$lang['AdminClients.services.heading_label'] = 'Etiqueta';
$lang['AdminClients.services.heading_term'] = 'Plazo';
$lang['AdminClients.services.heading_datecreated'] = 'Fecha de creación';
$lang['AdminClients.services.heading_daterenews'] = 'Fecha Renueva';
$lang['AdminClients.services.heading_datesuspended'] = 'Fecha de suspensión';
$lang['AdminClients.services.heading_datecanceled'] = 'Fecha de cancelación';
$lang['AdminClients.services.heading_options'] = 'Opciones';
$lang['AdminClients.services.category_active'] = 'Activo';
$lang['AdminClients.services.category_pending'] = 'Pendiente';
$lang['AdminClients.services.category_suspended'] = 'Suspendido';
$lang['AdminClients.services.category_canceled'] = 'Cancelado';
$lang['AdminClients.services.categorylink_newservice'] = 'Nuevo servicio';
$lang['AdminClients.services.recurring_term'] = '%1$s %2$s @ %3$s';
$lang['AdminClients.services.option_manage'] = 'Gestione';
$lang['AdminClients.services.option_delete'] = 'Borrar';
$lang['AdminClients.services.confirm_delete'] = '¿Está seguro de que desea eliminar este servicio?';
$lang['AdminClients.services.no_results'] = 'No hay servicios con este estatus.';
$lang['AdminClients.services.text_never'] = 'Nunca';
$lang['AdminClients.services.action.schedule_cancellation'] = 'Anulación de horarios';
$lang['AdminClients.services.action.invoice_renewal'] = 'Renovación de facturas';
$lang['AdminClients.services.action.push_to_client'] = 'Empujar al cliente';
$lang['AdminClients.services.action.field_action_type_term'] = 'Fin de plazo';
$lang['AdminClients.services.action.field_action_type_date'] = 'Fecha específica';
$lang['AdminClients.services.action.field_action_type_none'] = 'No cancelar';
$lang['AdminClients.services.action.field_cycles'] = 'Número de ciclos';
$lang['AdminClients.services.action.field_client'] = 'Cliente:';
$lang['AdminClients.services.field_actionsubmit'] = 'Enviar';
$lang['AdminClients.transactions.page_title'] = 'Cliente #%1$s Transacciones';
$lang['AdminClients.transactions.boxtitle_transactions'] = 'Transacciones';
$lang['AdminClients.transactions.heading_type'] = 'Tipo';
$lang['AdminClients.transactions.heading_amount'] = 'Importe';
$lang['AdminClients.transactions.heading_credited'] = 'Acreditado';
$lang['AdminClients.transactions.heading_applied'] = 'Aplicada';
$lang['AdminClients.transactions.heading_number'] = 'Número';
$lang['AdminClients.transactions.heading_reference_id'] = 'Referencia';
$lang['AdminClients.transactions.heading_date'] = 'Fecha';
$lang['AdminClients.transactions.heading_options'] = 'Opciones';
$lang['AdminClients.transactions.headingexpand_invoice'] = 'Factura';
$lang['AdminClients.transactions.headingexpand_amount'] = 'Importe';
$lang['AdminClients.transactions.headingexpand_appliedon'] = 'Aplicado en';
$lang['AdminClients.transactions.headingexpand_options'] = 'Opciones';
$lang['AdminClients.transactions.category_approved'] = 'Aprobado';
$lang['AdminClients.transactions.category_declined'] = 'Rechazado';
$lang['AdminClients.transactions.category_voided'] = 'Anulado';
$lang['AdminClients.transactions.category_error'] = 'Error';
$lang['AdminClients.transactions.category_pending'] = 'Pendiente';
$lang['AdminClients.transactions.category_refunded'] = 'Reembolsado';
$lang['AdminClients.transactions.category_returned'] = 'Devuelto';
$lang['AdminClients.transactions.categorylink_payment'] = 'Realizar el pago';
$lang['AdminClients.transactions.option_edit'] = 'Editar';
$lang['AdminClients.transactions.no_results'] = 'No hay transacciones con este estado.';
$lang['AdminClients.transactions.applied_no_results'] = 'Esta transacción no se ha aplicado a ninguna factura.';
$lang['AdminClients.view.page_title'] = 'Perfil del cliente #%1$s';
$lang['AdminClients.view.boxtitle_client'] = 'Cliente #%1$s';
$lang['AdminClients.view.boxtitle_contacts'] = 'Contactos';
$lang['AdminClients.view.status_link'] = '(Pulse para cambiar)';
$lang['AdminClients.view.number'] = '(%1$s %2$s)';
$lang['AdminClients.view.link_vcard'] = 'vCard';
$lang['AdminClients.view.link_notes'] = 'Notas';
$lang['AdminClients.view.link_editclient'] = 'Editar';
$lang['AdminClients.view.setting_memberof'] = 'Miembro de';
$lang['AdminClients.view.setting_invoicemethod'] = 'Método de facturación';
$lang['AdminClients.view.setting_autodebit'] = 'Débito automático';
$lang['AdminClients.view.setting_autosuspension'] = 'Suspensión';
$lang['AdminClients.view.setting_email_verification'] = 'Verificación del correo electrónico';
$lang['AdminClients.view.setting_sublogin'] = 'Inicio de sesión secundario';
$lang['AdminClients.view.setting_send_payment_notices'] = 'Avisos de pago';
$lang['AdminClients.view.setting_enabled'] = 'Activado';
$lang['AdminClients.view.setting_disabled'] = 'Discapacitados';
$lang['AdminClients.view.setting_verified'] = 'Verificado';
$lang['AdminClients.view.setting_unverified'] = 'Sin verificar';
$lang['AdminClients.view.setting_unsent'] = 'No enviado';
$lang['AdminClients.view.member_since'] = 'Miembro desde %1$s';
$lang['AdminClients.view.member_last_seen'] = 'Visto por última vez %1$s de';
$lang['AdminClients.view.member_last_seen_never'] = 'Visto por última vez';
$lang['AdminClients.view.tooltip_activity'] = 'Última actividad';
$lang['AdminClients.view.tooltip_location'] = 'Ubicación';
$lang['AdminClients.view.tooltip_last_activity_now'] = 'Ahora mismo';
$lang['AdminClients.view.tooltip_last_activity_minute'] = 'hace 1 minuto';
$lang['AdminClients.view.tooltip_last_activity_minutes'] = 'Hace %1$s minutos';
$lang['AdminClients.view.tooltip_autodebit_enabled'] = 'El cargo automático está activado, pero no se ha seleccionado ninguna cuenta de pago para el cargo automático. Debe seleccionarse una cuenta de pago para que se produzcan cargos automáticamente.';
$lang['AdminClients.view.delaysuspension_modal_title'] = 'Suspensión retardada';
$lang['AdminClients.view.actions_title'] = 'Acciones de la cuenta';
$lang['AdminClients.view.actionlink_createinvoice'] = 'Crear factura';
$lang['AdminClients.view.actionlink_addservice'] = 'Añadir servicio';
$lang['AdminClients.view.actionlink_addcontact'] = 'Añadir contacto';
$lang['AdminClients.view.actionlink_makepayment'] = 'Realizar el pago';
$lang['AdminClients.view.actionlink_recordpayment'] = 'Registre el pago';
$lang['AdminClients.view.actionlink_manageaccount'] = 'Cuentas de pago';
$lang['AdminClients.view.actionlink_addnote'] = 'Añadir nota';
$lang['AdminClients.view.actionlink_setpackages'] = 'Paquetes';
$lang['AdminClients.view.actionlink_passwordreset'] = 'Enviar restablecimiento de contraseña';
$lang['AdminClients.view.actionlink_viewmaillog'] = 'Ver el registro de correo';
$lang['AdminClients.view.actionlink_mergeclient'] = 'Fusionar cliente';
$lang['AdminClients.view.actionlink_deleteclient'] = 'Borrar cliente';
$lang['AdminClients.view.actionlink_emailclient'] = 'Cliente de correo electrónico';
$lang['AdminClients.view.actionlink_login'] = 'Iniciar sesión como cliente';
$lang['AdminClients.view.actionlink_more'] = 'Mostrar todas las acciones';
$lang['AdminClients.view.actionlink_less'] = 'Mostrar acciones comunes';
$lang['AdminClients.view.confirm_delete'] = '¿Está seguro de que desea eliminar este cliente?';
$lang['AdminClients.view.contact_type'] = '(%1$s)';
$lang['AdminClients.getcurrencyamounts.text_total_credits'] = 'Crédito total';
$lang['AdminClients.getcurrencyamounts.text_total_due'] = 'Total debido';
$lang['AdminClients.showcard.modal_title'] = 'Mostrar tarjeta';
$lang['AdminClients.showcard.field_passphrase'] = 'Frase de contraseña';
$lang['AdminClients.showcard.field_staff_password'] = 'Su contraseña de acceso';
$lang['AdminClients.showcard.field_submit'] = 'Enviar';
$lang['AdminClients.showcard.!error.passphrase'] = 'La contraseña no es válida.';
$lang['AdminClients.showcard.!error.password'] = 'La contraseña no es válida.';
$lang['AdminClients.showaccount.modal_title'] = 'Mostrar cuenta';
$lang['AdminClients.showaccount.field_passphrase'] = 'Frase de contraseña';
$lang['AdminClients.showaccount.field_staff_password'] = 'Su contraseña de acceso';
$lang['AdminClients.showaccount.field_submit'] = 'Enviar';
$lang['AdminClients.showaccount.!error.passphrase'] = 'La contraseña no es válida.';
$lang['AdminClients.showaccount.!error.password'] = 'La contraseña no es válida.';
$lang['AdminClients.packages.page_title'] = 'Cliente #%1$s Paquetes restringidos';
$lang['AdminClients.packages.boxtitle_packages'] = 'Paquetes restringidos';
$lang['AdminClients.packages.text_name'] = 'Nombre';
$lang['AdminClients.packages.text_module'] = 'Módulo';
$lang['AdminClients.packages.field_packagesubmit'] = 'Guardar acceso restringido a paquetes';
$lang['AdminClients.packages.no_results'] = 'No hay paquetes restringidos.';
$lang['AdminClients.delaysuspension.field_autosuspend_date'] = 'Fecha para retrasar la suspensión hasta';
$lang['AdminClients.delaysuspension.text_clear'] = 'Claro';
$lang['AdminClients.delaysuspension.field_save'] = 'Guardar';
$lang['AdminClients.delete.field_password'] = 'Introduzca su contraseña de acceso para confirmar';
$lang['AdminClients.delete.field_submit'] = 'Borrar';
$lang['AdminClients.!success.invoice_split'] = 'La factura #%1$s se ha dividido correctamente en la factura #%2$s.';
$lang['AdminClients.!success.services_resent'] = 'El correo electrónico de bienvenida para los servicios seleccionados se ha generado correctamente.';
$lang['AdminClients.add.field_recovery_email'] = 'Correo electrónico de recuperación (opcional)';
$lang['AdminClients.addcontact.field_recovery_email'] = 'Correo electrónico de recuperación (opcional)';
$lang['AdminClients.edit.field_recovery_email'] = 'Correo electrónico de recuperación (opcional)';
$lang['AdminClients.editcontact.field_recovery_email'] = 'Correo electrónico de recuperación (opcional)';
$lang['AdminClients.editinvoice.heading_split'] = 'Dividir';
$lang['AdminClients.editinvoice.field_invoicesplit'] = 'Factura dividida';
$lang['AdminClients.editinvoice.confirm_split'] = '¿Está seguro de dividir la factura?';
$lang['AdminClients.editservice.text_date_last_renewed'] = 'Fecha de la última renovación:';
$lang['AdminClients.services.action.resend_welcome_email'] = 'Reenviar correo de bienvenida';
$lang['AdminClients.editservice.field_date_last_renewed'] = 'Fecha de la última renovación';
$lang['AdminClients.editservice.field_date_renews'] = 'Fecha Renueva';
$lang['AdminClients.editservice.field_date_added'] = 'Fecha de creación';
$lang['AdminClients.editservice.service_fields_heading'] = 'Campos de servicio';
$lang['AdminClients.editservice.advanced_heading'] = 'Opciones avanzadas';
$lang['AdminClients.editservice.tooltip_disable_option_logic'] = 'Ignora las reglas que hacen que algunas opciones del paquete dependan de otras, permitiendo en su lugar que se establezca cualquier valor para las opciones del paquete.';
$lang['AdminClients.editservice.field_disable_option_logic'] = 'Desactivar la lógica de opciones';
$lang['AdminClients.editservice.text_manage_parent'] = 'Gestionar el Servicio de Padres';
$lang['AdminClients.editservice.service_parent'] = 'Servicio para padres';
$lang['AdminClients.editservice.tab_advanced'] = 'Opciones avanzadas';
$lang['AdminClients.addservice_basic.tooltip_disable_option_logic'] = 'Ignora las reglas que hacen que algunas opciones del paquete dependan de otras, permitiendo en su lugar que se establezca cualquier valor para las opciones del paquete.';
$lang['AdminClients.addservice_basic.field_disable_option_logic'] = 'Desactivar la lógica de opciones';
$lang['AdminClients.addservice_basic.field_override_price'] = 'Precio';
$lang['AdminClients.addservice_basic.field_price_override'] = 'Precio de anulación';
$lang['AdminClients.invoices.merge_placeholder'] = 'Factura de destino (opcional)';
$lang['AdminClients.add.heading_gateway_restrictions'] = 'Restricciones de acceso';
$lang['AdminClients.!notice.edit_service_advanced'] = 'Atención, modificar estos ajustes puede romper cosas si no sabes lo que estás haciendo, úsalo con precaución. Todos los cambios realizados aquí son internos a Blesta y no se enviarán llamadas API al módulo.';
$lang['AdminClients.!success.services_unsuspended'] = 'Los servicios seleccionados se han desbloqueado correctamente.';
$lang['AdminClients.!success.services_suspended'] = 'Los servicios seleccionados se han suspendido correctamente.';
$lang['AdminClients.!success.invoices_merged'] = 'Las facturas seleccionadas se han fusionado correctamente.';
$lang['AdminClients.invoices.action_merge'] = 'Fusionar facturas';
$lang['AdminClients.edit.field_inherit_gateway_restrictions'] = 'Heredar restricciones de gateway del grupo de clientes';
$lang['AdminClients.edit.heading_gateway_restrictions'] = 'Restricciones de acceso';
$lang['AdminClients.add.field_inherit_gateway_restrictions'] = 'Heredar restricciones de gateway del grupo de clientes';
$lang['AdminClients.services.action.field_suspension_reason'] = 'Motivo de la suspensión:';
$lang['AdminClients.services.action.unsuspend'] = 'Unsuspender';
$lang['AdminClients.services.action.suspend'] = 'Suspender';
$lang['AdminClients.editservice.field_date_canceled'] = 'Fecha de cancelación';
$lang['AdminClients.editservice.field_date_suspended'] = 'Fecha de suspensión';

